#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;

int convert(char C){
    if (C == 'S')
        return 1;
    if (C == 'I')
        return 0;
    if (C == 'O')
        return -1;
}

const int maxn = 300010;

void update(int& d1, int& d2, int c){
    if (c == 1)
        --d1;
    else if (c == 0){
        ++d1;
        --d2;
    } else
        ++d2;
}

int n;
ll sol;
vp e[maxn];
vi blok(maxn), d(maxn);

void depth(int x, int st){
    d[x] = 1;

    for (auto& i : e[x]){
        if (blok[i.first]  || st == i.first) continue;
        depth(i.first, x);
        d[x] += d[i.first];
    }
}

int c;
void centroid(int x, int st, int p){
    bool ok = 1;
    for (auto& i : e[x]){
        if (blok[i.first] || st == i.first) continue;
        if (2 * d[i.first] > p)
            ok = 0;
        centroid(i.first,x,p);
    }

    if (2 * (p - d[x]) > p)
        ok = 0;
    if (ok)
        c = x;
}

void dfs(int x, int st, int d1 = 0, int d2 = 0, int cnt = 0){
    if (d1 == 0 && d2 == 0 && cnt > 0)
        ++sol;

    for (auto& i : e[x]){
        if (i.first == st || blok[i.first]) continue;
        
        int nd1 = d1, nd2 = d2;

        update(nd1, nd2, i.second);

        dfs(i.first, x, nd1, nd2, cnt+1);
    }
}

vp tmp;
map<pi, int> cnt;

void calc(int x, int st, int d1, int d2){
    sol += cnt[{-d1, -d2}];
    tmp.push_back({d1, d2});

    for (auto& i : e[x]){
        if (blok[i.first] || i.first == st) continue;
        int nd1 = d1, nd2 = d2;

        update(nd1, nd2, i.second);
    
        calc(i.first, x, nd1, nd2);
    }
}

void solve(int x){
    depth(x, x);
    centroid(x, x, d[x]);   
    dfs(c, c);

    blok[c] = 1;
    cnt.clear();

    for (auto& i : e[c]){
        if (blok[i.first]) continue;

        int d1 = 0, d2 = 0;

        update(d1, d2, i.second);

        calc(i.first, i.first, d1, d2);

        while(!tmp.empty()){
            cnt[tmp.back()]++;
            tmp.pop_back();
        }
    }

    for (auto& i : e[c]){
        if (!blok[i.first])
            solve(i.first);
    }
}
//mt19937 eng(chrono::high_resolution_clock::now().time_since_epoch().count());
int main()
{//auto t0 = chrono::high_resolution_clock::now();
    
    //ifstream in;
    //in.open("test1.in");
    ios_base::sync_with_stdio(false); 
    cin.tie(nullptr); 
    cout.tie(nullptr); 
    cerr.tie(nullptr);    

    cin >> n;

    for (int i = 0; i < n - 1; ++i){
        int u, v;
        char C;
        cin >> u >> v >> C;

        e[u].push_back({v, convert(C)});
        e[v].push_back({u, convert(C)});
    }
    solve(1);
    //auto t1 = chrono::high_resolution_clock::now();
    //auto dur = t1 - t0;

    cout << sol << '\n';
    //cout << dur.count() << '\n';
}